<?php
/*
Plugin Name: Visual AMP Story Builder PRO
Description: Crie AMP Stories visualmente de forma simples
Version: 1.0.0
Author: Jeandro Oliveira
Text Domain: visual-amp-story-builder-pro
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// Constantes do sistema
define( 'VASB_PLUGIN_SLUG', 'visual-amp-story-builder-pro-settings' );
define( 'VASB_OPTION_GROUP', 'vasb_pro_options_group' );
define( 'VASB_OPTIONS_NAME', 'vasb_pro_global_settings' );
define( 'VASB_LICENSE_API_URL', 'https://amp.rojeandro.workers.dev' );
define( 'VASB_LICENSE_KEY_OPTION', 'vasb_pro_license_data' );

// Incluir arquivos de funcionalidades
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-cpt.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-settings.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-license.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-renderer.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-template.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/vasb-optimization.php';

// =============================================
// ATIVAÇÃO/DESATIVAÇÃO
// =============================================

function vasb_pro_activate() { 
    vasb_register_cpt(); 
    flush_rewrite_rules(); 
    set_transient( 'vasb_pro_activated', true, 30 );
}
register_activation_hook( __FILE__, 'vasb_pro_activate' );

function vasb_pro_deactivate() { 
    flush_rewrite_rules(); 
}
register_deactivation_hook( __FILE__, 'vasb_pro_deactivate' );

// Mensagem de ativação
function vasb_pro_admin_notice() {
    if ( get_transient( 'vasb_pro_activated' ) ) {
        ?>
        <div class="notice notice-success is-dismissible">
            <p>🎉 <strong>Visual AMP Story Builder PRO ativado!</strong> Configure a licença PRO em <a href="<?php echo admin_url('options-general.php?page=' . VASB_PLUGIN_SLUG); ?>">Configurações → Visual Story PRO</a>.</p>
        </div>
        <?php
        delete_transient( 'vasb_pro_activated' );
    }
}
add_action( 'admin_notices', 'vasb_pro_admin_notice' );

/** Load Text Domain */
function vasb_load_textdomain_pro() {
    load_plugin_textdomain( 'visual-amp-story-builder-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'vasb_load_textdomain_pro' );