// js/admin-media-helper.js
jQuery(document).ready(function($){
  var mediaUploader;

  $('body').on('click', '.vasb-upload-media', function(e){
      e.preventDefault();
      var button = $(this);
      var targetIdField = $('#' + button.data('target-id'));
      var targetPreview = $('#' + button.data('target-id') + '_preview');

      if (mediaUploader) {
          mediaUploader.open();
          return;
      }

      mediaUploader = wp.media.frames.file_frame = wp.media({
          title: 'Escolha uma Imagem',
          button: { text: 'Usar esta imagem' },
          multiple: false
      });

      mediaUploader.on('select', function(){
          var attachment = mediaUploader.state().get('selection').first().toJSON();
          targetIdField.val(attachment.id);
          targetPreview.attr('src', attachment.sizes && attachment.sizes.thumbnail ? attachment.sizes.thumbnail.url : attachment.url).show();
          button.siblings('.vasb-remove-media').show();
      });

      mediaUploader.open();
  });

  $('body').on('click', '.vasb-remove-media', function(e){
      e.preventDefault();
      var button = $(this);
      var targetIdField = $('#' + button.data('target-id'));
      var targetPreview = $('#' + button.data('target-id') + '_preview');
      
      targetIdField.val('');
      targetPreview.attr('src', '').hide();
      button.hide();
  });
});