<?php
/**
 * Template handler - Stories antigas funcionam, novas precisam de licença - CÓDIGO ORIGINAL
 */
function vasb_template_include_pro( $template ) {
    if ( is_singular( 'vasb_story' ) ) {
        $post_id = get_queried_object_id();
        $optimized_html = get_post_meta( $post_id, '_vasb_optimized_html', true );
        $license_data = vasb_check_license_status();
        
        // ✅ Stories antigas funcionam SEM licença
        if ( $optimized_html ) {
            echo $optimized_html;
            exit;
        } 
        // ❌ Stories novas PRECISAM de licença
        elseif ( $license_data ) {
            // Tem licença ativa - tenta renderizar a story se ainda não tiver HTML
            $success = vasb_background_render($post_id);
            if ($success) {
                $optimized_html = get_post_meta( $post_id, '_vasb_optimized_html', true );
            }
            
            if ( $optimized_html ) {
                echo $optimized_html;
                exit;
            } else {
                wp_die('Story em processamento... Tente atualizar a página em alguns segundos.');
            }
        } else {
            // ❌ Story nova SEM licença - BLOQUEIA
            wp_die(
                '<div style="text-align: center; padding: 50px 20px; font-family: Arial, sans-serif;">' .
                '<h1 style="color: #d63638;">📋 Story Não Disponível</h1>' .
                '<p style="font-size: 18px; margin: 20px 0;">Esta é uma <strong>nova Visual Story PRO</strong> que requer uma licença ativa.</p>' .
                '<div style="background: #f8f9fa; padding: 20px; border-radius: 8px; max-width: 500px; margin: 0 auto;">' .
                '<p style="margin: 0;"><strong>✅ Stories antigas continuam funcionando normalmente</strong></p>' .
                '<p style="margin: 10px 0 0 0; font-size: 14px; color: #666;">Se você já tinha stories criadas, elas continuam disponíveis.</p>' .
                '</div>' .
                '<p style="margin: 30px 0;">' .
                '<a href="' . admin_url('options-general.php?page=' . VASB_PLUGIN_SLUG) . '" style="background: #0073aa; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; display: inline-block;">' .
                '🚀 Ativar Licença PRO' .
                '</a>' .
                '</p>' .
                '</div>',
                'Story Não Disponível - Licença PRO Requerida',
                ['response' => 503]
            );
        }
    }
    return $template;
}
add_filter( 'template_include', 'vasb_template_include_pro', 99 );