<?php
// 2) Plugin Settings Page - CÓDIGO ORIGINAL
function vasb_add_admin_menu() {
    add_options_page(
        __( 'Visual AMP Story PRO Settings', 'visual-amp-story-builder-pro' ),
        __( 'Visual Story PRO', 'visual-amp-story-builder-pro' ),
        'manage_options',
        VASB_PLUGIN_SLUG,
        'vasb_options_page_html'
    );
}
add_action( 'admin_menu', 'vasb_add_admin_menu' );

function vasb_settings_init() {
    register_setting( VASB_OPTION_GROUP, VASB_OPTIONS_NAME, 'vasb_sanitize_global_options' );

    // Seção de Licença
//    add_settings_section(
//        'vasb_license_section',
//        __( 'Licença do Serviço PRO', 'visual-amp-story-builder-pro' ),
//        'vasb_license_section_cb',
//        VASB_PLUGIN_SLUG
//    );
//    add_settings_field( 
//        'license_key', 
//        __( 'Chave de Licença PRO', 'visual-amp-story-builder-pro' ), 
//        'vasb_license_field_cb', 
//        VASB_PLUGIN_SLUG, 
//        'vasb_license_section' 
//    );

    add_settings_section(
        'vasb_general_section',
        __( 'Configurações Gerais do Publisher', 'visual-amp-story-builder-pro' ),
        null,
        VASB_PLUGIN_SLUG
    );
    add_settings_field( 'publisher_name', __( 'Nome do Publisher', 'visual-amp-story-builder-pro' ), 'vasb_field_text_cb', VASB_PLUGIN_SLUG, 'vasb_general_section', ['id' => 'publisher_name', 'label_for' => 'publisher_name', 'desc' => __( 'Nome que aparecerá como publicador da story.', 'visual-amp-story-builder-pro' )] );
    add_settings_field( 'publisher_logo_id', __( 'Logo do Publisher', 'visual-amp-story-builder-pro' ), 'vasb_field_media_cb', VASB_PLUGIN_SLUG, 'vasb_general_section', ['id' => 'publisher_logo_id', 'label_for' => 'publisher_logo_id', 'desc' => __( 'Selecione a logo da biblioteca de mídia.', 'visual-amp-story-builder-pro' )] );

    add_settings_section(
        'vasb_monetization_section',
        __( 'Monetização e Analytics', 'visual-amp-story-builder-pro' ),
        null,
        VASB_PLUGIN_SLUG
    );
    add_settings_field( 'adsense_publisher_id', __( 'ID Publisher AdSense', 'visual-amp-story-builder-pro' ), 'vasb_field_text_cb', VASB_PLUGIN_SLUG, 'vasb_monetization_section', ['id' => 'adsense_publisher_id', 'label_for' => 'adsense_publisher_id'] );
    add_settings_field( 'adsense_slot_id', __( 'ID Slot AdSense Story', 'visual-amp-story-builder-pro' ), 'vasb_field_text_cb', VASB_PLUGIN_SLUG, 'vasb_monetization_section', ['id' => 'adsense_slot_id', 'label_for' => 'adsense_slot_id'] );
    add_settings_field( 'analytics_id', __( 'ID Google Analytics', 'visual-amp-story-builder-pro' ), 'vasb_field_text_cb', VASB_PLUGIN_SLUG, 'vasb_monetization_section', ['id' => 'analytics_id', 'label_for' => 'analytics_id'] );
}
add_action( 'admin_init', 'vasb_settings_init' );

// Callback da seção de licença - CÓDIGO ORIGINAL
function vasb_license_section_cb() {
    $license_data = get_option(VASB_LICENSE_KEY_OPTION);
    ?>
    <div class="vasb-license-status">
        <?php if ($license_data && $license_data['status'] === 'active'): ?>
            <div class="notice notice-success">
                <p>Cliente: <?php echo esc_html($license_data['customer']); ?></p>
                <p><small>Status: Todas as stories funcionam normalmente</small></p>
            </div>
        <?php else: ?>
            <div class="notice notice-warning">
                <p>⚠️ <strong>Licença PRO Não Ativa</strong> - Ative para criar NOVAS stories</p>
                <p><small><strong>Stories antigas continuam funcionando</strong> - apenas novas stories precisam de licença</small></p>
            </div>
        <?php endif; ?>
    </div>
    <?php
}

// Callback do campo de licença - CÓDIGO ORIGINAL
function vasb_license_field_cb() {
    $license_data = get_option(VASB_LICENSE_KEY_OPTION);
    $license_key = $license_data ? $license_data['license_key'] : '';
    ?>
    <input type="password" id="vasb_license_key" name="vasb_license_key" 
           value="<?php echo esc_attr($license_key); ?>" class="regular-text">
    <button type="button" id="vasb_activate_license" class="button button-primary">Ativar Licença</button>
    <button type="button" id="vasb_deactivate_license" class="button button-secondary" style="display: <?php echo $license_data ? 'inline-block' : 'none'; ?>">Desativar</button>
    
    <p class="description">
        Ative a licença para criar NOVAS Visual Stories PRO. Stories antigas continuam funcionando.
    </p>

    <script>
    jQuery(document).ready(function($) {
        $('#vasb_activate_license').on('click', function() {
            var licenseKey = $('#vasb_license_key').val();
            var button = $(this);
            
            if (!licenseKey) {
                alert('Por favor, insira uma chave de licença.');
                return;
            }
            
            button.text('Ativando...').prop('disabled', true);
            
            $.post(ajaxurl, {
                action: 'vasb_activate_license',
                license_key: licenseKey,
                nonce: '<?php echo wp_create_nonce("vasb_license_nonce"); ?>'
            }, function(response) {
                if (response.success) {
                    alert('✅ ' + response.data.message);
                    location.reload();
                } else {
                    alert('❌ ' + response.data.message);
                }
                button.text('Ativar Licença').prop('disabled', false);
            }).fail(function() {
                alert('❌ Erro na comunicação com o servidor.');
                button.text('Ativar Licença').prop('disabled', false);
            });
        });

        $('#vasb_deactivate_license').on('click', function() {
            if (confirm('Tem certeza que deseja desativar a licença? Novas stories não poderão ser criadas.')) {
                $.post(ajaxurl, {
                    action: 'vasb_deactivate_license',
                    nonce: '<?php echo wp_create_nonce("vasb_license_nonce"); ?>'
                }, function(response) {
                    if (response.success) {
                        alert('✅ Licença desativada com sucesso!');
                        location.reload();
                    }
                });
            }
        });
    });
    </script>
    <?php
}

// Funções de campos - CÓDIGO ORIGINAL
function vasb_field_text_cb( $args ) {
    $options = get_option( VASB_OPTIONS_NAME, [] );
    $value = isset( $options[$args['id']] ) ? $options[$args['id']] : '';
    echo '<input type="text" id="' . esc_attr( $args['id'] ) . '" name="' . VASB_OPTIONS_NAME . '[' . esc_attr( $args['id'] ) . ']" value="' . esc_attr( $value ) . '" class="regular-text">';
    if (isset($args['desc'])) {
        echo '<p class="description">' . esc_html($args['desc']) . '</p>';
    }
}

function vasb_field_media_cb( $args ) {
    $options = get_option( VASB_OPTIONS_NAME, [] );
    $value = isset( $options[$args['id']] ) ? intval($options[$args['id']]) : 0;
    $image_src = $value ? wp_get_attachment_image_url( $value, 'thumbnail' ) : '';
    ?>
    <img id="<?php echo esc_attr($args['id']); ?>_preview" src="<?php echo esc_url($image_src); ?>" style="max-width:100px; max-height:100px; display: <?php echo $value ? 'block' : 'none'; ?>; margin-bottom: 10px; border: 1px solid #ddd;">
    <input type="hidden" id="<?php echo esc_attr($args['id']); ?>" name="<?php echo VASB_OPTIONS_NAME . '[' . esc_attr($args['id']) . ']'; ?>" value="<?php echo esc_attr($value); ?>">
    <button type="button" class="button vasb-upload-media" data-target-id="<?php echo esc_attr($args['id']); ?>"><?php _e( 'Selecionar/Enviar Imagem', 'visual-amp-story-builder-pro' ); ?></button>
    <button type="button" class="button vasb-remove-media" data-target-id="<?php echo esc_attr($args['id']); ?>" style="display: <?php echo $value ? 'inline-block' : 'none'; ?>;"><?php _e( 'Remover Imagem', 'visual-amp-story-builder-pro' ); ?></button>
    <?php
    if (isset($args['desc'])) {
        echo '<p class="description">' . esc_html($args['desc']) . '</p>';
    }
}

function vasb_options_page_html() {
    if ( ! current_user_can( 'manage_options' ) ) return;
    ?>
    <div class="wrap">
        <h1><?php echo esc_html( get_admin_page_title() ); ?> <span style="font-size: 12px; background: #0073aa; color: white; padding: 2px 8px; border-radius: 10px;">PRO</span></h1>
        
        <div class="notice notice-info">
            <p><strong>✨ Sistema PRO Ativo</strong> - Todas as stories são processadas e otimizadas via Cloudflare Edge.</p>
        </div>
        
        <form action="options.php" method="post">
            <?php
            settings_fields( VASB_OPTION_GROUP );
            do_settings_sections( VASB_PLUGIN_SLUG );
            submit_button( __( 'Salvar Configurações PRO', 'visual-amp-story-builder-pro' ) );
            ?>
        </form>
        
        
        <div style="margin-top: 20px; text-align: center;">
            <a href="https://ibuma.com.br/plugin/contato" target="_blank" class="button">
                💬 Contato e Suporte
            </a>
        </div>
        
        
        
        
        <div style="margin-top: 30px; padding: 15px; background: #f7f7f7; border-radius: 5px;">
            <h3>📊 Status do Sistema</h3>
            <?php
            $license_data = get_option(VASB_LICENSE_KEY_OPTION);
            $stories_count = wp_count_posts('vasb_story');
            $optimized_stories = new WP_Query([
                'post_type' => 'vasb_story',
                'meta_key' => '_vasb_optimized_html',
                'posts_per_page' => -1
            ]);
            ?>
            <p>Stories Criadas: <strong><?php echo $stories_count->publish; ?></strong></p>
            <p>Stories Renderizadas: <strong><?php echo $optimized_stories->found_posts; ?></strong></p>
            <p>Status Cloudflare: <strong><?php echo $license_data ? '✅ Conectado' : '❌ Não conectado'; ?></strong></p>
        </div>
    </div>
    <?php
        
}

function vasb_sanitize_global_options( $input ) {
    $sanitized_input = array();
    if ( !is_array($input) ) $input = [];

    if ( isset( $input['publisher_name'] ) ) $sanitized_input['publisher_name'] = sanitize_text_field( $input['publisher_name'] );
    if ( isset( $input['publisher_logo_id'] ) ) $sanitized_input['publisher_logo_id'] = intval( $input['publisher_logo_id'] );
    if ( isset( $input['adsense_publisher_id'] ) ) $sanitized_input['adsense_publisher_id'] = sanitize_text_field( $input['adsense_publisher_id'] );
    if ( isset( $input['adsense_slot_id'] ) ) $sanitized_input['adsense_slot_id'] = sanitize_text_field( $input['adsense_slot_id'] );
    if ( isset( $input['analytics_id'] ) ) $sanitized_input['analytics_id'] = sanitize_text_field( $input['analytics_id'] );

    return $sanitized_input;
}

// =============================================
// SCRIPTS ADMIN - CÓDIGO ORIGINAL
// =============================================

function vasb_enqueue_admin_scripts_pro( $hook_suffix ) {
    if ( 'settings_page_' . VASB_PLUGIN_SLUG === $hook_suffix ||
         ( ($hook_suffix == 'post.php' || $hook_suffix == 'post-new.php') && get_post_type() == 'vasb_story' ) ) {
        wp_enqueue_media();
        wp_enqueue_script( 'jquery' );
        
        // Script para upload de mídia
        wp_add_inline_script( 'jquery', '
            jQuery(document).ready(function($) {
                // Upload de mídia
                $(".vasb-upload-media").on("click", function(e) {
                    e.preventDefault();
                    var targetId = $(this).data("target-id");
                    var frame = wp.media({
                        title: "Selecionar Imagem",
                        multiple: false,
                        library: { type: "image" }
                    });
                    
                    frame.on("select", function() {
                        var attachment = frame.state().get("selection").first().toJSON();
                        $("#" + targetId).val(attachment.id);
                        $("#" + targetId + "_preview").attr("src", attachment.url).show();
                        $(".vasb-remove-media[data-target-id=\"" + targetId + "\"]").show();
                    });
                    
                    frame.open();
                });
                
                // Remover mídia
                $(".vasb-remove-media").on("click", function(e) {
                    e.preventDefault();
                    var targetId = $(this).data("target-id");
                    $("#" + targetId).val("");
                    $("#" + targetId + "_preview").hide();
                    $(this).hide();
                });
            });
        ');
    }
}
add_action( 'admin_enqueue_scripts', 'vasb_enqueue_admin_scripts_pro' );