<?php
// =============================================
// OTIMIZAÇÃO: ATIVAÇÃO AUTOMÁTICA DE LICENÇA PARA TESTES - CÓDIGO ORIGINAL
// =============================================

/**
 * Ativação automática de licença para facilitar testes - CÓDIGO ORIGINAL
 */
function vasb_auto_activate_license() {
    // Se não há licença ativa, ativa uma automaticamente
    $license_data = get_option(VASB_LICENSE_KEY_OPTION);
    if (!$license_data || $license_data['status'] !== 'active') {
        $license_data = [
            'license_key' => 'PRO_AUTO_123',
            'status' => 'active',
            'expires' => '2030-12-31',
            'customer' => get_bloginfo('name') . ' (Auto)',
            'last_check' => time(),
            'auto_activated' => true
        ];
        update_option(VASB_LICENSE_KEY_OPTION, $license_data);
        
        error_log('VASB PRO: Licença ativada automaticamente para testes');
    }
}
add_action('init', 'vasb_auto_activate_license');