<?php
/**
 * Sistema de ativação de licença - CÓDIGO ORIGINAL
 */
function vasb_activate_license($license_key) {
    $response = wp_remote_post(VASB_LICENSE_API_URL . '/activate', [
        'headers' => ['Content-Type' => 'application/json'],
        'body' => json_encode([
            'license_key' => sanitize_text_field($license_key),
            'site_url' => home_url(),
            'site_name' => get_bloginfo('name'),
            'action' => 'activate'
        ]),
        'timeout' => 15
    ]);

    if (is_wp_error($response)) {
        return ['success' => false, 'message' => 'Erro de conexão: ' . $response->get_error_message()];
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (isset($data['success']) && $data['success']) {
        update_option(VASB_LICENSE_KEY_OPTION, [
            'license_key' => sanitize_text_field($license_key),
            'status' => 'active',
           
            'customer' => $data['customer'] ?? 'Cliente PRO',
            'last_check' => time()
        ]);
        return $data;
    } else {
        return [
            'success' => false, 
            'message' => $data['message'] ?? 'Erro desconhecido na ativação'
        ];
    }
}

/**
 * Verificar status da licença - CÓDIGO ORIGINAL
 */
function vasb_check_license_status() {
    $license_data = get_option(VASB_LICENSE_KEY_OPTION);
    
    if (!$license_data || $license_data['status'] !== 'active') {
        return false;
    }

    // Verificar a cada 7 dias
    $last_check = $license_data['last_check'] ?? 0;
    if (time() - $last_check < 604800) {
        return $license_data;
    }

    $response = wp_remote_post(VASB_LICENSE_API_URL . '/verify', [
        'headers' => ['Content-Type' => 'application/json'],
        'body' => json_encode([
            'license_key' => $license_data['license_key'],
            'site_url' => home_url(),
            'action' => 'verify'
        ])
    ]);

    if (!is_wp_error($response)) {
        $data = json_decode(wp_remote_retrieve_body($response), true);
        if (isset($data['success']) && $data['success']) {
            $license_data['last_check'] = time();
            update_option(VASB_LICENSE_KEY_OPTION, $license_data);
        } else {
            update_option(VASB_LICENSE_KEY_OPTION, ['status' => 'invalid']);
            return false;
        }
    }

    return $license_data;
}

// AJAX para ativar licença - CÓDIGO ORIGINAL
function vasb_ajax_activate_license() {
    check_ajax_referer('vasb_license_nonce', 'nonce');
    
    $license_key = sanitize_text_field($_POST['license_key']);
    $result = vasb_activate_license($license_key);
    
    if ($result['success']) {
        wp_send_json_success(['message' => 'Licença PRO ativada com sucesso! Agora você pode criar novas stories.']);
    } else {
        wp_send_json_error(['message' => $result['message']]);
    }
}
add_action('wp_ajax_vasb_activate_license', 'vasb_ajax_activate_license');

// AJAX para desativar licença - CÓDIGO ORIGINAL
function vasb_ajax_deactivate_license() {
    check_ajax_referer('vasb_license_nonce', 'nonce');
    
    delete_option(VASB_LICENSE_KEY_OPTION);
    wp_send_json_success(['message' => 'Licença desativada. Stories antigas continuam funcionando.']);
}
add_action('wp_ajax_vasb_deactivate_license', 'vasb_ajax_deactivate_license');