<?php
// 1) Register CPT 'vasb_story' - CÓDIGO ORIGINAL
function vasb_register_cpt() {
    $labels = array(
        'name'               => _x( 'Visual Stories PRO', 'post type general name', 'visual-amp-story-builder-pro' ),
        'singular_name'      => _x( 'Visual Story PRO', 'post type singular name', 'visual-amp-story-builder-pro' ),
        'menu_name'          => _x( 'Visual Stories PRO', 'admin menu', 'visual-amp-story-builder-pro' ),
        'name_admin_bar'     => _x( 'Visual Story PRO', 'add new on admin bar', 'visual-amp-story-builder-pro' ),
        'add_new'            => _x( 'Adicionar Nova', 'visual story', 'visual-amp-story-builder-pro' ),
        'add_new_item'       => __( 'Adicionar Nova Visual Story', 'visual-amp-story-builder-pro' ),
        'new_item'           => __( 'Nova Visual Story', 'visual-amp-story-builder-pro' ),
        'edit_item'          => __( 'Editar Visual Story', 'visual-amp-story-builder-pro' ),
        'view_item'          => __( 'Ver Visual Story', 'visual-amp-story-builder-pro' ),
        'all_items'          => __( 'Todas Visual Stories', 'visual-amp-story-builder-pro' ),
        'search_items'       => __( 'Procurar Visual Stories', 'visual-amp-story-builder-pro' ),
        'parent_item_colon'  => __( 'Visual Story Pai:', 'visual-amp-story-builder-pro' ),
        'not_found'          => __( 'Nenhuma Visual Story encontrada.', 'visual-amp-story-builder-pro' ),
        'not_found_in_trash' => __( 'Nenhuma Visual Story encontrada na lixeira.', 'visual-amp-story-builder-pro' )
    );
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'amp', 'with_front' => false ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 20,
        'supports'           => array( 'title', 'thumbnail', 'excerpt' ),
        'show_in_rest'       => true,
        'menu_icon'          => 'dashicons-slides',
    );
    register_post_type( 'vasb_story', $args );
}
add_action( 'init', 'vasb_register_cpt' );

// 3) Meta Boxes para o CPT 'vasb_story' - CÓDIGO ORIGINAL
function vasb_add_meta_boxes() {
    add_meta_box(
        'vasb_story_styling_mb',
        __( 'Estilização da Story PRO', 'visual-amp-story-builder-pro' ),
        'vasb_story_styling_mb_cb',
        'vasb_story', 'normal', 'high'
    );
    add_meta_box(
        'vasb_story_pages_content_mb',
        __( 'Conteúdo das Páginas da Story', 'visual-amp-story-builder-pro' ),
        'vasb_story_pages_content_mb_cb',
        'vasb_story', 'normal', 'high'
    );

    // Meta Box de Status PRO
    add_meta_box(
        'vasb_story_pro_status_mb',
        __( 'Status PRO - Renderização Cloudflare', 'visual-amp-story-builder-pro' ),
        'vasb_story_pro_status_mb_cb',
        'vasb_story', 'side', 'high'
    );
}
add_action( 'add_meta_boxes', 'vasb_add_meta_boxes' );

function vasb_story_styling_mb_cb( $post ) {
    wp_nonce_field( 'vasb_save_story_meta', 'vasb_nonce' );
    $bg_color = get_post_meta( $post->ID, '_vasb_page_bg_color', true ) ?: '#222222';
    $text_color = get_post_meta( $post->ID, '_vasb_page_text_color', true ) ?: '#FFFFFF';
    $font_family = get_post_meta( $post->ID, '_vasb_font_family', true ) ?: 'Helvetica, Arial, sans-serif';
    $page_font_size = get_post_meta( $post->ID, '_vasb_page_font_size', true ) ?: '22';

    $bg_density_raw = get_post_meta( $post->ID, '_vasb_bg_density', true );
    $bg_density = (is_numeric($bg_density_raw) && $bg_density_raw >= 0 && $bg_density_raw <=1) ? floatval($bg_density_raw) : '0.5';

    $text_position = get_post_meta( $post->ID, '_vasb_text_position', true ) ?: 'center';
    $text_bg_style = get_post_meta( $post->ID, '_vasb_text_bg_style', true ) ?: 'none';
    ?>
    <p style="margin-bottom: 15px;">
        <label for="vasb_page_bg_color" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Cor Base:', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <input type="color" id="vasb_page_bg_color" name="vasb_page_bg_color" value="<?php echo esc_attr( $bg_color ); ?>">
    </p>
    <p style="margin-bottom: 15px;">
        <label for="vasb_page_text_color" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Cor do Texto:', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <input type="color" id="vasb_page_text_color" name="vasb_page_text_color" value="<?php echo esc_attr( $text_color ); ?>">
    </p>
    <p style="margin-bottom: 15px;">
        <label for="vasb_font_family" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Família da Fonte:', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <select id="vasb_font_family" name="vasb_font_family">
            <option value="Helvetica, Arial, sans-serif" <?php selected( $font_family, "Helvetica, Arial, sans-serif" ); ?>>Helvetica/Arial</option>
            <option value="Georgia, serif" <?php selected( $font_family, "Georgia, serif" ); ?>>Georgia</option>
            <option value="'Times New Roman', Times, serif" <?php selected( $font_family, "'Times New Roman', Times, serif" ); ?>>Times New Roman</option>
            <option value="Verdana, Geneva, sans-serif" <?php selected( $font_family, "Verdana, Geneva, sans-serif" ); ?>>Verdana</option>
        </select>
    </p>
    <p style="margin-bottom: 15px;">
        <label for="vasb_page_font_size" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Tamanho da Fonte (px):', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <input type="number" id="vasb_page_font_size" name="vasb_page_font_size" value="<?php echo esc_attr( $page_font_size ); ?>" min="10" max="72" step="1" style="width: 80px;">
    </p>
    <p style="margin-bottom: 15px;">
        <label for="vasb_text_bg_style" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Efeito de Fundo:', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <select id="vasb_text_bg_style" name="vasb_text_bg_style">
            <option value="none" <?php selected( $text_bg_style, 'none' ); ?>><?php _e('Nenhum', 'visual-amp-story-builder-pro'); ?></option>
            <option value="overlay_image" <?php selected( $text_bg_style, 'overlay_image' ); ?>><?php _e('Overlay na Imagem', 'visual-amp-story-builder-pro'); ?></option>
            <option value="highlight_text" <?php selected( $text_bg_style, 'highlight_text' ); ?>><?php _e('Painel de Fundo', 'visual-amp-story-builder-pro'); ?></option>
        </select>
    </p>
     <p style="margin-bottom: 15px;">
        <label for="vasb_bg_density" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Densidade (0.0 a 1.0):', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <input type="number" step="0.1" min="0" max="1" id="vasb_bg_density" name="vasb_bg_density" value="<?php echo esc_attr( $bg_density ); ?>" style="width: 80px;">
    </p>
    <p style="margin-bottom: 15px;">
        <label for="vasb_text_position" style="display:block; margin-bottom:5px;"><strong><?php _e( 'Posição do Texto:', 'visual-amp-story-builder-pro' ); ?></strong></label>
        <select id="vasb_text_position" name="vasb_text_position">
            <option value="flex-start" <?php selected( $text_position, 'flex-start' ); ?>><?php _e('Superior', 'visual-amp-story-builder-pro'); ?></option>
            <option value="center" <?php selected( $text_position, 'center' ); ?>><?php _e('Centro', 'visual-amp-story-builder-pro'); ?></option>
            <option value="flex-end" <?php selected( $text_position, 'flex-end' ); ?>><?php _e('Inferior', 'visual-amp-story-builder-pro'); ?></option>
        </select>
    </p>
    <?php
}

function vasb_story_pages_content_mb_cb( $post ) {
    $pages_content_raw = get_post_meta( $post->ID, '_vasb_pages_content_raw', true );
    ?>
    <p><?php _e( 'Insira o conteúdo de cada página em uma nova linha.', 'visual-amp-story-builder-pro' ); ?></p>
    <p><strong><?php _e( 'Formato por linha:', 'visual-amp-story-builder-pro' ); ?></strong></p>
    <ul>
        <li><code>TEXTO DA PÁGINA (ID_DA_IMAGEM_FUNDO) (cta:TEXTO_BOTAO:URL_COMPLETO)</code></li>
        <li><code>Texto (video:123)</code> para vídeos self-hosted</li>
    </ul>
     <p><em><?php _e( 'Exemplo:', 'visual-amp-story-builder-pro' ); ?></em></p>
     <pre style="background:#f7f7f7;padding:10px;border:1px solid #ddd;">Esta é a minha primeira página! (123) (cta:Saiba Mais:https://exemplo.com)
Mais conteúdo aqui. (123)
Assista ao nosso vídeo exclusivo (video:123)</pre>

<!-- ✅ BOTÃO ESTILO WORDPRESS -->
<div style="background: #f8f9fa; padding: 15px; border-radius: 6px; margin: 15px 0; text-align: center; border-left: 4px solid #46b450;">
    <p style="margin: 0 0 10px 0; font-size: 14px; color: #2d5016;">
        🎨 <strong>Ferramenta gratuita:</strong> Gere imagens otimizadas para Web Stories
    </p>
    <a href="https://ibuma.com.br/gerar-imagem-para-web-story" target="_blank" class="button button-primary" style="font-size: 13px; padding: 8px 16px;">
        🚀 Gerar Imagens para Web Story
    </a>
</div>



    <textarea name="vasb_pages_content_raw" rows="15" style="width:100%; font-family:monospace; white-space: pre-wrap; overflow-x: auto;"><?php echo esc_textarea( $pages_content_raw ); ?></textarea>
    <?php
}

// Meta Box de Status PRO - CÓDIGO MODIFICADO (usando worker separado)
function vasb_story_pro_status_mb_cb( $post ) {
    $optimized_html = get_post_meta( $post->ID, '_vasb_optimized_html', true );
    $last_optimized = get_post_meta( $post->ID, '_vasb_last_optimized', true );
    $domain = parse_url(home_url(), PHP_URL_HOST);

    // ✅ CONSULTA WORKER DE VERIFICAÇÃO
    $license_info = vasb_check_license_with_worker($domain);
    ?>

    <div class="vasb-pro-status">
        <!-- STATUS DA LICENÇA -->
        <div style="background: <?php echo $license_info['bg_color']; ?>; padding: 12px; border-radius: 6px; margin-bottom: 15px; border-left: 4px solid <?php echo $license_info['border_color']; ?>;">
            <p style="margin: 0 0 5px 0; color: <?php echo $license_info['text_color']; ?>; font-weight: 600;">
                <?php echo $license_info['icon']; ?> <?php echo $license_info['status_text']; ?>
            </p>
            <p style="margin: 0; font-size: 12px; color: <?php echo $license_info['text_color']; ?>;">
                <strong>Domínio:</strong> <?php echo $domain; ?>
            </p>
            <?php if ($license_info['expiration']): ?>
                <p style="margin: 5px 0 0 0; font-size: 12px; color: <?php echo $license_info['text_color']; ?>;">
                    <strong>Expira em:</strong> <?php echo $license_info['expiration']; ?>
                </p>
            <?php endif; ?>
        </div>

        <!-- O RESTANTE DO CÓDIGO PERMANECE EXATAMENTE IGUAL -->
        <?php if ( $optimized_html ): ?>
            <div style="background: #e1f5fe; padding: 10px; border-radius: 4px; margin-bottom: 15px;">
                <p style="margin: 0; color: #01579b;">⚡ <strong>Story Renderizada</strong></p>
                <p style="margin: 5px 0 0 0; font-size: 12px;">
                    Última renderização: <?php echo $last_optimized ? date('d/m/Y H:i', $last_optimized) : 'N/A'; ?>
                </p>
                <p style="margin: 5px 0 0 0; font-size: 12px; color: #2d5016;">
                    ✅ <strong>Funciona sem licença</strong> - Esta story é legada
                </p>
            </div>
            <button type="button" id="vasb_reoptimize_story" class="button button-secondary" style="width: 100%;"
                    <?php echo !$license_info['can_render'] ? 'disabled' : ''; ?>>
                🔄 Re-renderizar Agora
            </button>
        <?php elseif ( $license_info['can_render'] ): ?>
            <div style="background: #edf7ed; padding: 10px; border-radius: 4px; margin-bottom: 15px;">
                <p style="margin: 0; color: #2d5016;">✅ <strong>Licença PRO Ativa</strong></p>
                <p style="margin: 5px 0 0 0; font-size: 12px;">Esta story será renderizada ao salvar.</p>
            </div>
        <?php else: ?>
            <div style="background: #fff3cd; padding: 10px; border-radius: 4px; margin-bottom: 15px;">
                <p style="margin: 0; color: #856404;">⚠️ <strong>Story Não Renderizada</strong></p>
                <p style="margin: 5px 0 0 0; font-size: 12px;">
                    <strong>Esta story NÃO será exibida</strong> até que a licença seja ativada.
                </p>
            </div>
            <p style="margin-top: 10px; font-size: 12px;">
                <a href="https://wa.me/5535998874585?text=Olá! Gostaria de cadastrar meu domínio: <?php echo urlencode($domain); ?>"
                   class="button button-primary" style="width: 100%; text-align: center;" target="_blank">
                    💬 Cadastrar Domínio via WhatsApp
                </a>
            </p>
        <?php endif; ?>
    </div>

    <script>
    jQuery(document).ready(function($) {
        $('#vasb_reoptimize_story').on('click', function() {
            var button = $(this);
            button.text('Renderizando...').prop('disabled', true);

            $.post(ajaxurl, {
                action: 'vasb_reoptimize_story',
                post_id: <?php echo $post->ID; ?>,
                nonce: '<?php echo wp_create_nonce("vasb_reoptimize_nonce"); ?>'
            }, function(response) {
                if (response.success) {
                    alert('✅ Story re-renderizada com sucesso!');
                    location.reload();
                } else {
                    alert('❌ ' + response.data.message);
                }
                button.text('🔄 Re-renderizar Agora').prop('disabled', false);
            });
        });
    });
    </script>
    <?php
}

// ✅ FUNÇÃO AUXILIAR PARA CONSULTAR O WORKER
function vasb_check_license_with_worker($domain) {
    $worker_url = 'https://showval.rojeandro.workers.dev/verificar-licenca';

    $default_response = [
        'registered' => false,
        'valid' => false,
        'status_text' => 'Erro na verificação',
        'icon' => '❌',
        'bg_color' => '#fff3cd',
        'border_color' => '#856404',
        'text_color' => '#856404',
        'expiration' => null,
        'can_render' => false
    ];

    try {
        $response = wp_remote_get($worker_url . '?domain=' . urlencode($domain), [
            'timeout' => 10,
            'sslverify' => false
        ]);

        if (is_wp_error($response)) {
            return $default_response;
        }

        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        if (!$data || !$data['success']) {
            return $default_response;
        }

        // Domínio não cadastrado
        if (!$data['registered']) {
            return [
                'registered' => false,
                'valid' => false,
                'status_text' => 'Domínio não cadastrado',
                'icon' => '❌',
                'bg_color' => '#fff3cd',
                'border_color' => '#856404',
                'text_color' => '#856404',
                'expiration' => null,
                'can_render' => false
            ];
        }

        // Domínio cadastrado mas expirado
        if (!$data['valid']) {
            $expiration_date = $data['expiration'] ? date('d/m/Y', strtotime($data['expiration'])) : 'Data inválida';
            return [
                'registered' => true,
                'valid' => false,
                'status_text' => 'Licença expirada',
                'icon' => '⚠️',
                'bg_color' => '#fff3cd',
                'border_color' => '#d97706',
                'text_color' => '#d97706',
                'expiration' => $expiration_date,
                'can_render' => false
            ];
        }

        // Domínio cadastrado e ativo
        $expiration_date = $data['expiration'] ? date('d/m/Y', strtotime($data['expiration'])) : null;
        return [
            'registered' => true,
            'valid' => true,
            'status_text' => 'Licença ativa' . ($data['expires_in_days'] ? " ({$data['expires_in_days']} dias)" : ''),
            'icon' => '✅',
            'bg_color' => '#edf7ed',
            'border_color' => '#2d5016',
            'text_color' => '#2d5016',
            'expiration' => $expiration_date,
            'can_render' => true
        ];

    } catch (Exception $e) {
        return $default_response;
    }
}







// Save Meta Data - CÓDIGO ORIGINAL COMPLETO
function vasb_save_meta_data( $post_id ) {
    if ( ! isset( $_POST['vasb_nonce'] ) || ! wp_verify_nonce( $_POST['vasb_nonce'], 'vasb_save_story_meta' ) ) return;
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( ! current_user_can( 'edit_post', $post_id ) ) return;
    if ( get_post_type( $post_id ) !== 'vasb_story' ) return;

    $styling_fields_map = [
        'vasb_page_bg_color' => 'sanitize_hex_color',
        'vasb_page_text_color' => 'sanitize_hex_color',
        'vasb_font_family' => 'sanitize_text_field',
        'vasb_bg_density' => 'vasb_sanitize_float_0_1',
        'vasb_text_position' => 'sanitize_key',
        'vasb_text_bg_style' => 'sanitize_key'
    ];

    if ( ! function_exists( 'sanitize_hex_color' ) ) {
        function sanitize_hex_color( $color ) {
            if ( '' === $color ) return '';
            if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) return $color;
            return null;
        }
    }

    foreach ( $styling_fields_map as $key => $sanitize_callback ) {
        if ( isset( $_POST[$key] ) ) {
            $value = $_POST[$key];
            if (is_callable($sanitize_callback)) {
                $value = call_user_func( $sanitize_callback, $value );
            } else {
                $value = sanitize_text_field( $value );
            }

            if ($key === 'vasb_text_position' && !in_array($value, ['flex-start', 'center', 'flex-end'])) { $value = 'center'; }
            if ($key === 'vasb_text_bg_style' && !in_array($value, ['none', 'overlay_image', 'highlight_text'])) { $value = 'none'; }
            if ($key === 'vasb_font_family') {
                $allowed_fonts = ['Helvetica, Arial, sans-serif', 'Georgia, serif', "'Times New Roman', Times, serif", "Verdana, Geneva, sans-serif", "'Courier New', Courier, monospace", 'sans-serif', 'serif', 'monospace'];
                if (!in_array($value, $allowed_fonts)) { $value = 'Helvetica, Arial, sans-serif'; }
            }
            if ( ($key === 'vasb_page_bg_color' || $key === 'vasb_page_text_color') && is_null($value) ) {
                $value = ($key === 'vasb_page_bg_color') ? '#222222' : '#FFFFFF';
            }

            update_post_meta( $post_id, '_' . $key, $value );
        }
    }

    // Salvar tamanho da fonte
    if (isset($_POST['vasb_page_font_size'])) {
        $font_size = intval($_POST['vasb_page_font_size']);
        if ($font_size < 10 || $font_size > 72) { $font_size = 22; }
        update_post_meta($post_id, '_vasb_page_font_size', $font_size);
    } else {
        if ( get_post_meta( $post_id, '_vasb_page_font_size', true ) === '' ) {
             update_post_meta($post_id, '_vasb_page_font_size', 22);
        }
    }

    if ( isset( $_POST['vasb_pages_content_raw'] ) ) {
        update_post_meta( $post_id, '_vasb_pages_content_raw', sanitize_textarea_field( $_POST['vasb_pages_content_raw'] ) );
    }
}
add_action( 'save_post_vasb_story', 'vasb_save_meta_data' );

// Helper functions - CÓDIGO ORIGINAL
function vasb_sanitize_float_0_1( $value ) {
    $value = floatval( str_replace(',', '.', $value) );
    return max(0.0, min(1.0, $value));
}